# Łamanie szyfru przestawieniowego:
# https://www.nostarch.com/crackingcodes (na licencji BSD).

import time, os, sys, transpositionDecrypt, detectEnglish

inputFilename = 'frankenstein.encrypted.txt'
outputFilename = 'frankenstein.decrypted.txt'

def main():
    if not os.path.exists(inputFilename):
        print('Plik %s nie istnieje. Koniec pracy.' % (inputFilename))
        sys.exit()

    inputFile = open(inputFilename)
    content = inputFile.read()
    inputFile.close()

    hackedMessage = hackTransposition(content)

    if hackedMessage != None:
        print('Zapisywanie deszyfrowanej wiadomości do pliku %s.' % (outputFilename))

        outputFile = open(outputFilename, 'w')
        outputFile.write(hackedMessage)
        outputFile.close()
    else:
        print('Deszyfrowanie zakończyło się niepowodzeniem.')


# Kod funkcji hackTransposition() został skopiowany z pliku
# transpositionHacker.py i zawiera kilka modyfikacji.
def hackTransposition(message):
    print('Łamanie szyfru...')
    # Program Pythona można zatrzymać w dowolnym momencie przez naciśnięcie klawiszy
    # Ctrl+C (Windows) lub Ctrl+D (macOS i Linux).
    print('(Naciśnij klawisze Ctrl+C lub Ctrl+D, aby w dowolnym momencie zakończyć działanie programu.)')

    for key in range(1, len(message)):
        print('Sprawdzanie klucza #%s... ' % (key), end='')
        sys.stdout.flush()

        # Chcemy ustalić ilość czasu potrzebnego na sprawdzenie danego klucza,
        # więc w zmiennej startTime przechowujemy godzinę rozpoczęcia operacji.
        startTime = time.time()

        decryptedText = transpositionDecrypt.decryptMessage(key, message)
        englishPercentage = round(detectEnglish.getEnglishCount(decryptedText) * 100, 2)

        totalTime = round(time.time() - startTime, 3)
        print('Czas: %s sekund, ' % (totalTime), end='')
        sys.stdout.flush() # Wyczyszczenie ekranu.

        print('Procentowa ilość tekstu angielskiego: %s%%' % (englishPercentage))
        if englishPercentage > 20:
            print()
            print('Klucz ' + str(key) + ': ' + decryptedText[:100])
            print()
            print('Wpisz D, aby zakończyć. Dowolny inny klawisz kontynuuje łamanie szyfru:')
            response = input('> ')
            if response.strip().upper().startswith('D'):
                return decryptedText
    return None


# Jeżeli program transpositionFileHacker.py został uruchomiony (a nie
# zaimportowany jako moduł), wówczas należy wywołać funkcję main().
if __name__ == '__main__':
    main()
